/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool.ha;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.ha.HighAvailableDataSource;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;

public class DataSourceCreator {
    private static final Log LOG = LogFactory.getLog(DataSourceCreator.class);
    private Properties properties = new Properties();
    private List<String> nameList = new ArrayList<String>();

    public DataSourceCreator(String file) {
        this.loadProperties(file);
        this.loadNameList();
    }

    public Map<String, DataSource> createMap(HighAvailableDataSource haDataSource) throws SQLException {
        ConcurrentHashMap<String, DataSource> map = new ConcurrentHashMap<String, DataSource>();
        if (this.nameList == null || this.nameList.isEmpty()) {
            LOG.error("No DataSource will be created!");
            return map;
        }
        for (String n : this.nameList) {
            String url = this.properties.getProperty(n + ".url");
            String username = this.properties.getProperty(n + ".username");
            String password = this.properties.getProperty(n + ".password");
            LOG.info("Creating " + n + " with url[" + url + "] and username[" + username + "].");
            DruidDataSource dataSource = this.create(n, url, username, password, haDataSource);
            map.put(n, dataSource);
        }
        LOG.info(map.size() + " DruidDataSource(s) created. ");
        return map;
    }

    protected DruidDataSource create(String name, String url, String username, String password, HighAvailableDataSource haDataSource) throws SQLException {
        DruidDataSource dataSource = new DruidDataSource();
        dataSource.setName(name + "-" + System.identityHashCode(dataSource));
        dataSource.setUrl(url);
        dataSource.setUsername(username);
        dataSource.setPassword(password);
        dataSource.setDriverClassName(haDataSource.getDriverClassName());
        dataSource.setConnectProperties(haDataSource.getConnectProperties());
        dataSource.setConnectionProperties(haDataSource.getConnectionProperties());
        dataSource.setInitialSize(haDataSource.getInitialSize());
        dataSource.setMaxActive(haDataSource.getMaxActive());
        dataSource.setMinIdle(haDataSource.getMinIdle());
        dataSource.setMaxWait(haDataSource.getMaxWait());
        dataSource.setValidationQuery(haDataSource.getValidationQuery());
        dataSource.setValidationQueryTimeout(haDataSource.getValidationQueryTimeout());
        dataSource.setTestOnBorrow(haDataSource.isTestOnBorrow());
        dataSource.setTestOnReturn(haDataSource.isTestOnReturn());
        dataSource.setTestWhileIdle(haDataSource.isTestWhileIdle());
        dataSource.setPoolPreparedStatements(haDataSource.isPoolPreparedStatements());
        dataSource.setSharePreparedStatements(haDataSource.isSharePreparedStatements());
        dataSource.setMaxPoolPreparedStatementPerConnectionSize(haDataSource.getMaxPoolPreparedStatementPerConnectionSize());
        dataSource.setQueryTimeout(haDataSource.getQueryTimeout());
        dataSource.setTransactionQueryTimeout(haDataSource.getTransactionQueryTimeout());
        dataSource.setTimeBetweenEvictionRunsMillis(haDataSource.getTimeBetweenEvictionRunsMillis());
        dataSource.setMinEvictableIdleTimeMillis(haDataSource.getMinEvictableIdleTimeMillis());
        dataSource.setMaxEvictableIdleTimeMillis(haDataSource.getMaxEvictableIdleTimeMillis());
        dataSource.setPhyTimeoutMillis(haDataSource.getPhyTimeoutMillis());
        dataSource.setTimeBetweenConnectErrorMillis(haDataSource.getTimeBetweenConnectErrorMillis());
        dataSource.setRemoveAbandoned(haDataSource.isRemoveAbandoned());
        dataSource.setRemoveAbandonedTimeoutMillis(haDataSource.getRemoveAbandonedTimeoutMillis());
        dataSource.setLogAbandoned(haDataSource.isLogAbandoned());
        dataSource.setProxyFilters(haDataSource.getProxyFilters());
        dataSource.setFilters(haDataSource.getFilters());
        dataSource.setLogWriter(haDataSource.getLogWriter());
        dataSource.init();
        return dataSource;
    }

    private void loadNameList() {
        HashSet<String> names = new HashSet<String>();
        for (String n : this.properties.stringPropertyNames()) {
            if (!n.contains(".url")) continue;
            names.add(n.split("\\.url")[0]);
        }
        if (!names.isEmpty()) {
            this.nameList.addAll(names);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties(String file) {
        Properties properties = new Properties();
        if (file == null) {
            return;
        }
        InputStream is = null;
        try {
            LOG.debug("Trying to load " + file + " from FileSystem.");
            is = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            LOG.debug("Trying to load " + file + " from Classpath.");
            try {
                is = DataSourceCreator.class.getResourceAsStream(file);
            }
            catch (Exception ex) {
                LOG.warn("Can not load resource " + file, ex);
            }
        }
        if (is != null) {
            try {
                properties.load(is);
                this.properties = properties;
            }
            catch (Exception e) {
                LOG.error("Exception occurred while loading " + file, e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
            }
        } else {
            LOG.warn("File " + file + " can't be loaded!");
        }
    }
}

