/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.parser;

import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2SelectQueryBlock;
import com.alibaba.druid.sql.dialect.db2.parser.DB2ExprParser;
import com.alibaba.druid.sql.dialect.db2.parser.DB2Lexer;
import com.alibaba.druid.sql.dialect.db2.parser.DB2StatementParser;
import com.alibaba.druid.sql.dialect.h2.parser.H2StatementParser;
import com.alibaba.druid.sql.dialect.hive.parser.HiveStatementParser;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlExprParser;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlLexer;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlStatementParser;
import com.alibaba.druid.sql.dialect.odps.parser.OdpsExprParser;
import com.alibaba.druid.sql.dialect.odps.parser.OdpsLexer;
import com.alibaba.druid.sql.dialect.odps.parser.OdpsStatementParser;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectQueryBlock;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleExprParser;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleLexer;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleStatementParser;
import com.alibaba.druid.sql.dialect.phoenix.parser.PhoenixExprParser;
import com.alibaba.druid.sql.dialect.phoenix.parser.PhoenixLexer;
import com.alibaba.druid.sql.dialect.phoenix.parser.PhoenixStatementParser;
import com.alibaba.druid.sql.dialect.postgresql.parser.PGExprParser;
import com.alibaba.druid.sql.dialect.postgresql.parser.PGLexer;
import com.alibaba.druid.sql.dialect.postgresql.parser.PGSQLStatementParser;
import com.alibaba.druid.sql.dialect.sqlserver.parser.SQLServerExprParser;
import com.alibaba.druid.sql.dialect.sqlserver.parser.SQLServerLexer;
import com.alibaba.druid.sql.dialect.sqlserver.parser.SQLServerStatementParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.SQLStatementParser;

public class SQLParserUtils {
    public static SQLStatementParser createSQLStatementParser(String sql, String dbType) {
        SQLParserFeature[] features = "odps".equals(dbType) || "mysql".equals(dbType) ? new SQLParserFeature[]{SQLParserFeature.KeepComments} : new SQLParserFeature[]{};
        return SQLParserUtils.createSQLStatementParser(sql, dbType, features);
    }

    public static SQLStatementParser createSQLStatementParser(String sql, String dbType, boolean keepComments) {
        SQLParserFeature[] features = keepComments ? new SQLParserFeature[]{SQLParserFeature.KeepComments} : new SQLParserFeature[]{};
        return SQLParserUtils.createSQLStatementParser(sql, dbType, features);
    }

    public static SQLStatementParser createSQLStatementParser(String sql, String dbType, SQLParserFeature ... features) {
        if ("oracle".equals(dbType) || "AliOracle".equals(dbType)) {
            return new OracleStatementParser(sql);
        }
        if ("mysql".equals(dbType) || "aliyun_drds".equals(dbType)) {
            return new MySqlStatementParser(sql, features);
        }
        if ("mariadb".equals(dbType)) {
            return new MySqlStatementParser(sql, features);
        }
        if ("postgresql".equals(dbType) || "edb".equals(dbType)) {
            return new PGSQLStatementParser(sql);
        }
        if ("sqlserver".equals(dbType) || "jtds".equals(dbType)) {
            return new SQLServerStatementParser(sql);
        }
        if ("h2".equals(dbType)) {
            return new H2StatementParser(sql);
        }
        if ("db2".equals(dbType)) {
            return new DB2StatementParser(sql);
        }
        if ("odps".equals(dbType)) {
            return new OdpsStatementParser(sql);
        }
        if ("phoenix".equals(dbType)) {
            return new PhoenixStatementParser(sql);
        }
        if ("hive".equals(dbType)) {
            return new HiveStatementParser(sql);
        }
        if ("elastic_search".equals(dbType)) {
            return new MySqlStatementParser(sql);
        }
        return new SQLStatementParser(sql, dbType);
    }

    public static SQLExprParser createExprParser(String sql, String dbType) {
        if ("oracle".equals(dbType) || "AliOracle".equals(dbType)) {
            return new OracleExprParser(sql);
        }
        if ("mysql".equals(dbType) || "mariadb".equals(dbType) || "h2".equals(dbType)) {
            return new MySqlExprParser(sql);
        }
        if ("postgresql".equals(dbType) || "edb".equals(dbType)) {
            return new PGExprParser(sql);
        }
        if ("sqlserver".equals(dbType) || "jtds".equals(dbType)) {
            return new SQLServerExprParser(sql);
        }
        if ("db2".equals(dbType)) {
            return new DB2ExprParser(sql);
        }
        if ("odps".equals(dbType)) {
            return new OdpsExprParser(sql);
        }
        if ("phoenix".equals(dbType)) {
            return new PhoenixExprParser(sql);
        }
        return new SQLExprParser(sql);
    }

    public static Lexer createLexer(String sql, String dbType) {
        if ("oracle".equals(dbType) || "AliOracle".equals(dbType)) {
            return new OracleLexer(sql);
        }
        if ("mysql".equals(dbType) || "mariadb".equals(dbType) || "h2".equals(dbType)) {
            return new MySqlLexer(sql);
        }
        if ("postgresql".equals(dbType) || "edb".equals(dbType)) {
            return new PGLexer(sql, new SQLParserFeature[0]);
        }
        if ("sqlserver".equals(dbType) || "jtds".equals(dbType)) {
            return new SQLServerLexer(sql);
        }
        if ("db2".equals(dbType)) {
            return new DB2Lexer(sql);
        }
        if ("odps".equals(dbType)) {
            return new OdpsLexer(sql);
        }
        if ("phoenix".equals(dbType)) {
            return new PhoenixLexer(sql);
        }
        return new Lexer(sql);
    }

    public static SQLSelectQueryBlock createSelectQueryBlock(String dbType) {
        if ("mysql".equals(dbType)) {
            return new MySqlSelectQueryBlock();
        }
        if ("oracle".equals(dbType)) {
            return new OracleSelectQueryBlock();
        }
        if ("db2".equals(dbType)) {
            return new DB2SelectQueryBlock();
        }
        if ("postgresql".equals(dbType)) {
            return new DB2SelectQueryBlock();
        }
        if ("odps".equals(dbType)) {
            return new DB2SelectQueryBlock();
        }
        if ("sqlserver".equals(dbType)) {
            return new DB2SelectQueryBlock();
        }
        return new SQLSelectQueryBlock();
    }
}

