/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.system.oshi;

import cn.hutool.system.oshi.CpuInfo;
import java.text.DecimalFormat;
import java.util.List;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.ComputerSystem;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HWDiskStore;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.NetworkIF;
import oshi.hardware.Sensors;
import oshi.software.os.OperatingSystem;
import oshi.util.Util;

public class OshiUtil {
    private static final SystemInfo systemInfo = new SystemInfo();
    private static final HardwareAbstractionLayer hardware = systemInfo.getHardware();
    private static final OperatingSystem os = systemInfo.getOperatingSystem();

    public static OperatingSystem getOs() {
        return os;
    }

    public static HardwareAbstractionLayer getHardware() {
        return hardware;
    }

    public static ComputerSystem getSystem() {
        return hardware.getComputerSystem();
    }

    public static GlobalMemory getMemory() {
        return hardware.getMemory();
    }

    public static CentralProcessor getProcessor() {
        return hardware.getProcessor();
    }

    public static Sensors getSensors() {
        return hardware.getSensors();
    }

    public static List<HWDiskStore> getDiskStores() {
        return hardware.getDiskStores();
    }

    public static List<NetworkIF> getNetworkIFs() {
        return hardware.getNetworkIFs();
    }

    public static CpuInfo getCpuInfo() {
        return OshiUtil.getCpuInfo(1000L);
    }

    public static CpuInfo getCpuInfo(long waitingTime) {
        return OshiUtil.getCpuInfo(OshiUtil.getProcessor(), waitingTime);
    }

    private static CpuInfo getCpuInfo(CentralProcessor processor, long waitingTime) {
        CpuInfo cpuInfo = new CpuInfo();
        long[] prevTicks = processor.getSystemCpuLoadTicks();
        Util.sleep((long)waitingTime);
        long[] ticks = processor.getSystemCpuLoadTicks();
        long nice = ticks[CentralProcessor.TickType.NICE.getIndex()] - prevTicks[CentralProcessor.TickType.NICE.getIndex()];
        long irq = ticks[CentralProcessor.TickType.IRQ.getIndex()] - prevTicks[CentralProcessor.TickType.IRQ.getIndex()];
        long softIrq = ticks[CentralProcessor.TickType.SOFTIRQ.getIndex()] - prevTicks[CentralProcessor.TickType.SOFTIRQ.getIndex()];
        long steal = ticks[CentralProcessor.TickType.STEAL.getIndex()] - prevTicks[CentralProcessor.TickType.STEAL.getIndex()];
        long cSys = ticks[CentralProcessor.TickType.SYSTEM.getIndex()] - prevTicks[CentralProcessor.TickType.SYSTEM.getIndex()];
        long user = ticks[CentralProcessor.TickType.USER.getIndex()] - prevTicks[CentralProcessor.TickType.USER.getIndex()];
        long ioWait = ticks[CentralProcessor.TickType.IOWAIT.getIndex()] - prevTicks[CentralProcessor.TickType.IOWAIT.getIndex()];
        long idle = ticks[CentralProcessor.TickType.IDLE.getIndex()] - prevTicks[CentralProcessor.TickType.IDLE.getIndex()];
        long totalCpu = Math.max(user + nice + cSys + idle + ioWait + irq + softIrq + steal, 0L);
        DecimalFormat format = new DecimalFormat("#.00");
        cpuInfo.setCpuNum(processor.getLogicalProcessorCount());
        cpuInfo.setToTal(totalCpu);
        cpuInfo.setSys(Double.parseDouble(format.format(cSys <= 0L ? 0.0 : 100.0 * (double)cSys / (double)totalCpu)));
        cpuInfo.setUsed(Double.parseDouble(format.format(user <= 0L ? 0.0 : 100.0 * (double)user / (double)totalCpu)));
        if (totalCpu == 0L) {
            cpuInfo.setWait(0.0);
        } else {
            cpuInfo.setWait(Double.parseDouble(format.format(100.0 * (double)ioWait / (double)totalCpu)));
        }
        cpuInfo.setFree(Double.parseDouble(format.format(idle <= 0L ? 0.0 : 100.0 * (double)idle / (double)totalCpu)));
        cpuInfo.setCpuModel(processor.toString());
        return cpuInfo;
    }
}

