/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.sql;

import cn.hutool.core.clone.CloneSupport;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.StrSpliter;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.sql.LogicalOperator;
import cn.hutool.db.sql.SqlUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class Condition
extends CloneSupport<Condition> {
    private static final String OPERATOR_LIKE = "LIKE";
    private static final String OPERATOR_IN = "IN";
    private static final String OPERATOR_IS = "IS";
    private static final String OPERATOR_IS_NOT = "IS NOT";
    private static final String OPERATOR_BETWEEN = "BETWEEN";
    private static final List<String> OPERATORS = Arrays.asList("<>", "<=", "<", ">=", ">", "=", "!=", "IN");
    private static final String VALUE_NULL = "NULL";
    private String field;
    private String operator;
    private Object value;
    private boolean isPlaceHolder = true;
    private Object secondValue;
    private LogicalOperator linkOperator = LogicalOperator.AND;

    public static Condition parse(String field, Object expression) {
        return new Condition(field, expression);
    }

    public Condition() {
    }

    public Condition(boolean isPlaceHolder) {
        this.isPlaceHolder = isPlaceHolder;
    }

    public Condition(String field, Object value) {
        this(field, "=", value);
        this.parseValue();
    }

    public Condition(String field, String operator, Object value) {
        this.field = field;
        this.operator = operator;
        this.value = value;
    }

    public Condition(String field, String value, LikeType likeType) {
        this.field = field;
        this.operator = OPERATOR_LIKE;
        this.value = SqlUtil.buildLikeValue(value, likeType, false);
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.setValue(value, false);
    }

    public void setValue(Object value, boolean isParse) {
        this.value = value;
        if (isParse) {
            this.parseValue();
        }
    }

    public boolean isPlaceHolder() {
        return this.isPlaceHolder;
    }

    public void setPlaceHolder(boolean isPlaceHolder) {
        this.isPlaceHolder = isPlaceHolder;
    }

    public boolean isOperatorBetween() {
        return OPERATOR_BETWEEN.equalsIgnoreCase(this.operator);
    }

    public boolean isOperatorIn() {
        return OPERATOR_IN.equalsIgnoreCase(this.operator);
    }

    public boolean isOperatorIs() {
        return OPERATOR_IS.equalsIgnoreCase(this.operator);
    }

    public Condition checkValueNull() {
        if (null == this.value) {
            this.operator = OPERATOR_IS;
            this.value = VALUE_NULL;
        }
        return this;
    }

    public Object getSecondValue() {
        return this.secondValue;
    }

    public void setSecondValue(Object secondValue) {
        this.secondValue = secondValue;
    }

    public LogicalOperator getLinkOperator() {
        return this.linkOperator;
    }

    public void setLinkOperator(LogicalOperator linkOperator) {
        this.linkOperator = linkOperator;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(List<Object> paramValues) {
        StringBuilder conditionStrBuilder = StrUtil.builder();
        this.checkValueNull();
        conditionStrBuilder.append(this.field).append(" ").append(this.operator);
        if (this.isOperatorBetween()) {
            this.buildValuePartForBETWEEN(conditionStrBuilder, paramValues);
        } else if (this.isOperatorIn()) {
            this.buildValuePartForIN(conditionStrBuilder, paramValues);
        } else if (this.isPlaceHolder() && !this.isOperatorIs()) {
            conditionStrBuilder.append(" ?");
            if (null != paramValues) {
                paramValues.add(this.value);
            }
        } else {
            conditionStrBuilder.append(" ").append(this.value);
        }
        return conditionStrBuilder.toString();
    }

    private void buildValuePartForBETWEEN(StringBuilder conditionStrBuilder, List<Object> paramValues) {
        if (this.isPlaceHolder()) {
            conditionStrBuilder.append(" ?");
            if (null != paramValues) {
                paramValues.add(this.value);
            }
        } else {
            conditionStrBuilder.append(' ').append(this.value);
        }
        conditionStrBuilder.append(" ").append(LogicalOperator.AND.toString());
        if (this.isPlaceHolder()) {
            conditionStrBuilder.append(" ?");
            if (null != paramValues) {
                paramValues.add(this.secondValue);
            }
        } else {
            conditionStrBuilder.append(' ').append(this.secondValue);
        }
    }

    private void buildValuePartForIN(StringBuilder conditionStrBuilder, List<Object> paramValues) {
        conditionStrBuilder.append(" (");
        Object value = this.value;
        if (this.isPlaceHolder()) {
            List<Object> valuesForIn = value instanceof CharSequence ? StrUtil.split((CharSequence)value, ',') : Arrays.asList((Object[])Convert.convert(String[].class, value));
            conditionStrBuilder.append(StrUtil.repeatAndJoin("?", valuesForIn.size(), ","));
            if (null != paramValues) {
                paramValues.addAll(valuesForIn);
            }
        } else {
            conditionStrBuilder.append(StrUtil.join((CharSequence)",", value));
        }
        conditionStrBuilder.append(')');
    }

    private void parseValue() {
        List<String> strs;
        if (null == this.value) {
            this.operator = OPERATOR_IS;
            this.value = VALUE_NULL;
            return;
        }
        if (this.value instanceof Collection || ArrayUtil.isArray(this.value)) {
            this.operator = OPERATOR_IN;
            return;
        }
        if (!(this.value instanceof String)) {
            return;
        }
        String valueStr = (String)this.value;
        if (StrUtil.isBlank(valueStr)) {
            return;
        }
        if (StrUtil.endWithIgnoreCase(valueStr = StrUtil.trim(valueStr), "null")) {
            if (StrUtil.equalsIgnoreCase("= null", valueStr) || StrUtil.equalsIgnoreCase("is null", valueStr)) {
                this.operator = OPERATOR_IS;
                this.value = VALUE_NULL;
                this.isPlaceHolder = false;
                return;
            }
            if (StrUtil.equalsIgnoreCase("!= null", valueStr) || StrUtil.equalsIgnoreCase("is not null", valueStr)) {
                this.operator = OPERATOR_IS_NOT;
                this.value = VALUE_NULL;
                this.isPlaceHolder = false;
                return;
            }
        }
        if ((strs = StrUtil.split(valueStr, ' ', 2)).size() < 2) {
            return;
        }
        String firstPart = strs.get(0).trim().toUpperCase();
        if (OPERATORS.contains(firstPart)) {
            this.operator = firstPart;
            String valuePart = strs.get(1);
            this.value = this.isOperatorIn() ? valuePart : Condition.tryToNumber(valuePart);
            return;
        }
        if (OPERATOR_LIKE.equals(firstPart)) {
            this.operator = OPERATOR_LIKE;
            this.value = Condition.unwrapQuote(strs.get(1));
            return;
        }
        if (OPERATOR_BETWEEN.equals(firstPart)) {
            List<String> betweenValueStrs = StrSpliter.splitTrimIgnoreCase(strs.get(1), LogicalOperator.AND.toString(), 2, true);
            if (betweenValueStrs.size() < 2) {
                return;
            }
            this.operator = OPERATOR_BETWEEN;
            this.value = Condition.unwrapQuote(betweenValueStrs.get(0));
            this.secondValue = Condition.unwrapQuote(betweenValueStrs.get(1));
        }
    }

    private static String unwrapQuote(String value) {
        char endChar;
        if (null == value) {
            return null;
        }
        value = value.trim();
        int from = 0;
        int to = value.length();
        char startChar = value.charAt(0);
        if (startChar == (endChar = value.charAt(value.length() - 1)) && ('\'' == startChar || '\"' == startChar)) {
            from = 1;
            --to;
        }
        if (from == 0) {
            return value;
        }
        return value.substring(from, to);
    }

    private static Object tryToNumber(String value) {
        if (!NumberUtil.isNumber(value = StrUtil.trim(value))) {
            return value;
        }
        try {
            return NumberUtil.parseNumber(value);
        }
        catch (Exception ignore) {
            return value;
        }
    }

    public static enum LikeType {
        StartWith,
        EndWith,
        Contains;

    }
}

