/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.plugins.pagination.dialects;

import com.baomidou.mybatisplus.extension.plugins.pagination.DialectModel;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.IDialect;

public class SybaseDialect
implements IDialect {
    private final boolean hasTop;

    public SybaseDialect() {
        this(false);
    }

    public SybaseDialect(boolean hasTop) {
        this.hasTop = hasTop;
    }

    @Override
    public DialectModel buildPaginationSql(String originalSql, long offset, long limit) {
        int index = originalSql.indexOf("FROM");
        String sql = "select";
        if (this.hasTop) {
            sql = sql + " top " + (offset + limit);
        }
        sql = sql + " rownum=identity(12)," + originalSql.substring(6, index) + " into #t " + originalSql.substring(index);
        sql = sql + " select * from #t where rownum > ? and rownum <= ? ";
        sql = sql + "drop table #t ";
        return new DialectModel(sql, offset, offset + limit).setConsumerChain();
    }
}

