/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.support.atomic;

import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.SessionCallback;
import org.springframework.util.CollectionUtils;

class CompareAndSet<T>
implements SessionCallback<Boolean> {
    private final Supplier<T> getter;
    private final Consumer<T> setter;
    private final Object key;
    private final T expect;
    private final T update;

    @Override
    public <K, V> Boolean execute(RedisOperations<K, V> operations) throws DataAccessException {
        operations.watch(this.key);
        if (this.expect.equals(this.getter.get())) {
            operations.multi();
            this.setter.accept(this.update);
            if (CompareAndSet.updateSuccessful(operations.exec())) {
                return true;
            }
        }
        operations.unwatch();
        return false;
    }

    private static boolean updateSuccessful(Collection<?> exec) {
        return !CollectionUtils.isEmpty(exec);
    }

    public CompareAndSet(Supplier<T> getter, Consumer<T> setter, Object key, T expect, T update) {
        this.getter = getter;
        this.setter = setter;
        this.key = key;
        this.expect = expect;
        this.update = update;
    }
}

