/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.boot.context.properties.ConfigurationPropertiesBean;
import org.springframework.boot.context.properties.ConfigurationPropertiesBindException;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinder;

final class ConfigurationPropertiesValueObjectBeanDefinition
extends GenericBeanDefinition {
    private final BeanFactory beanFactory;
    private final String beanName;

    ConfigurationPropertiesValueObjectBeanDefinition(BeanFactory beanFactory, String beanName, Class<?> beanClass) {
        this.beanFactory = beanFactory;
        this.beanName = beanName;
        this.setBeanClass(beanClass);
        this.setInstanceSupplier(this::createBean);
    }

    private Object createBean() {
        ConfigurationPropertiesBean bean = ConfigurationPropertiesBean.forValueObject(this.getBeanClass(), this.beanName);
        ConfigurationPropertiesBinder binder = ConfigurationPropertiesBinder.get(this.beanFactory);
        try {
            return binder.bindOrCreate(bean);
        }
        catch (Exception ex) {
            throw new ConfigurationPropertiesBindException(bean, ex);
        }
    }
}

