/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.data.connection;

import java.util.ArrayList;
import org.redisson.api.RFuture;
import org.redisson.client.BaseRedisPubSubListener;
import org.redisson.client.ChannelName;
import org.redisson.client.RedisPubSubListener;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.pubsub.PubSubType;
import org.redisson.connection.ConnectionManager;
import org.redisson.pubsub.PublishSubscribeService;
import org.springframework.data.redis.connection.DefaultMessage;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.util.AbstractSubscription;

public class RedissonSubscription
extends AbstractSubscription {
    private final ConnectionManager connectionManager;
    private final PublishSubscribeService subscribeService;

    public RedissonSubscription(ConnectionManager connectionManager, PublishSubscribeService subscribeService, MessageListener listener) {
        super(listener, null, null);
        this.connectionManager = connectionManager;
        this.subscribeService = subscribeService;
    }

    protected void doSubscribe(byte[] ... channels) {
        BaseRedisPubSubListener listener2 = new BaseRedisPubSubListener(){

            public void onMessage(CharSequence channel, Object message) {
                DefaultMessage msg = new DefaultMessage(((ChannelName)channel).getName(), (byte[])message);
                RedissonSubscription.this.getListener().onMessage((Message)msg, null);
            }
        };
        ArrayList<RFuture> list = new ArrayList<RFuture>();
        for (byte[] channel : channels) {
            RFuture f = this.subscribeService.subscribe((Codec)ByteArrayCodec.INSTANCE, new ChannelName(channel), new RedisPubSubListener[]{listener2});
            list.add(f);
        }
        Object object = list.iterator();
        while (object.hasNext()) {
            RFuture future = (RFuture)object.next();
            this.connectionManager.getCommandExecutor().syncSubscription(future);
        }
    }

    protected void doUnsubscribe(boolean all, byte[] ... channels) {
        for (byte[] channel : channels) {
            this.subscribeService.unsubscribe(new ChannelName(channel), PubSubType.UNSUBSCRIBE);
        }
    }

    protected void doPsubscribe(byte[] ... patterns) {
        BaseRedisPubSubListener listener2 = new BaseRedisPubSubListener(){

            public void onPatternMessage(CharSequence pattern, CharSequence channel, Object message) {
                DefaultMessage msg = new DefaultMessage(((ChannelName)channel).getName(), (byte[])message);
                RedissonSubscription.this.getListener().onMessage((Message)msg, ((ChannelName)pattern).getName());
            }
        };
        ArrayList<RFuture> list = new ArrayList<RFuture>();
        for (byte[] channel : patterns) {
            RFuture f = this.subscribeService.psubscribe(new ChannelName(channel), (Codec)ByteArrayCodec.INSTANCE, new RedisPubSubListener[]{listener2});
            list.add(f);
        }
        Object object = list.iterator();
        while (object.hasNext()) {
            RFuture future = (RFuture)object.next();
            this.connectionManager.getCommandExecutor().syncSubscription(future);
        }
    }

    protected void doPUnsubscribe(boolean all, byte[] ... patterns) {
        for (byte[] pattern : patterns) {
            this.subscribeService.unsubscribe(new ChannelName(pattern), PubSubType.PUNSUBSCRIBE);
        }
    }

    protected void doClose() {
        this.doUnsubscribe(false, (byte[][])this.getChannels().toArray((T[])new byte[this.getChannels().size()][]));
        this.doPUnsubscribe(false, (byte[][])this.getPatterns().toArray((T[])new byte[this.getPatterns().size()][]));
    }
}

