/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api.junit.jupiter;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Optional;
import org.assertj.core.api.SoftAssertionsProvider;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.annotation.Testable;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.ReflectionSupport;

public class SoftAssertionsExtension
implements ParameterResolver,
AfterTestExecutionCallback {
    private static final ExtensionContext.Namespace SOFT_ASSERTIONS_EXTENSION_NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{SoftAssertionsExtension.class});

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        boolean isTestableMethod;
        if (SoftAssertionsExtension.isUnsupportedParameterType(parameterContext.getParameter())) {
            return false;
        }
        Executable executable = parameterContext.getDeclaringExecutable();
        boolean bl = isTestableMethod = executable instanceof Method && AnnotationSupport.isAnnotated((AnnotatedElement)executable, Testable.class);
        if (!isTestableMethod) {
            throw new ParameterResolutionException(String.format("Configuration error: cannot resolve SoftAssertionsProvider instances for [%s]. Only test methods are supported.", executable));
        }
        Class<?> parameterType = parameterContext.getParameter().getType();
        if (Modifier.isAbstract(parameterType.getModifiers())) {
            throw new ParameterResolutionException(String.format("Configuration error: the resolved SoftAssertionsProvider implementation [%s] is abstract and cannot be instantiated.", executable));
        }
        try {
            parameterType.getDeclaredConstructor(new Class[0]);
        }
        catch (Exception e) {
            throw new ParameterResolutionException(String.format("Configuration error: the resolved SoftAssertionsProvider implementation [%s] has no default constructor and cannot be instantiated.", executable));
        }
        return true;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Class<?> concreteSoftAssertionsProviderType = parameterContext.getParameter().getType();
        return SoftAssertionsExtension.getStore(extensionContext).getOrComputeIfAbsent(SoftAssertionsProvider.class, unused -> (SoftAssertionsProvider)ReflectionSupport.newInstance((Class)concreteSoftAssertionsProviderType, (Object[])new Object[0]), SoftAssertionsProvider.class);
    }

    public void afterTestExecution(ExtensionContext extensionContext) {
        Optional.ofNullable((SoftAssertionsProvider)SoftAssertionsExtension.getStore(extensionContext).remove(SoftAssertionsProvider.class, SoftAssertionsProvider.class)).ifPresent(SoftAssertionsProvider::assertAll);
    }

    private static boolean isUnsupportedParameterType(Parameter parameter) {
        Class<?> type = parameter.getType();
        return !SoftAssertionsProvider.class.isAssignableFrom(type);
    }

    private static ExtensionContext.Store getStore(ExtensionContext extensionContext) {
        return extensionContext.getStore(SOFT_ASSERTIONS_EXTENSION_NAMESPACE);
    }
}

