/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.support;

import io.lettuce.core.RedisConnectionException;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.support.AsyncObjectFactory;
import io.lettuce.core.support.AsyncPool;
import io.lettuce.core.support.BoundedAsyncPool;
import io.lettuce.core.support.BoundedPoolConfig;
import io.lettuce.core.support.ConnectionWrapping;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public abstract class AsyncConnectionPoolSupport {
    private AsyncConnectionPoolSupport() {
    }

    public static <T extends StatefulConnection<?, ?>> BoundedAsyncPool<T> createBoundedObjectPool(Supplier<CompletionStage<T>> connectionSupplier, BoundedPoolConfig config) {
        return AsyncConnectionPoolSupport.createBoundedObjectPool(connectionSupplier, config, true);
    }

    public static <T extends StatefulConnection<?, ?>> BoundedAsyncPool<T> createBoundedObjectPool(Supplier<CompletionStage<T>> connectionSupplier, BoundedPoolConfig config, boolean wrapConnections) {
        BoundedAsyncPool<T> pool = AsyncConnectionPoolSupport.doCreatePool(connectionSupplier, config, wrapConnections);
        pool.createIdle();
        return pool;
    }

    public static <T extends StatefulConnection<?, ?>> CompletionStage<BoundedAsyncPool<T>> createBoundedObjectPoolAsync(Supplier<CompletionStage<T>> connectionSupplier, BoundedPoolConfig config) {
        return AsyncConnectionPoolSupport.createBoundedObjectPoolAsync(connectionSupplier, config, true);
    }

    public static <T extends StatefulConnection<?, ?>> CompletionStage<BoundedAsyncPool<T>> createBoundedObjectPoolAsync(Supplier<CompletionStage<T>> connectionSupplier, BoundedPoolConfig config, boolean wrapConnections) {
        BoundedAsyncPool pool = AsyncConnectionPoolSupport.doCreatePool(connectionSupplier, config, wrapConnections);
        CompletableFuture future = new CompletableFuture();
        pool.createIdle().whenComplete((v, throwable) -> {
            if (throwable == null) {
                future.complete(pool);
            } else {
                pool.closeAsync().whenComplete((v1, throwable1) -> future.completeExceptionally(new RedisConnectionException("Could not create pool", (Throwable)throwable)));
            }
        });
        return future;
    }

    protected static <T extends StatefulConnection<?, ?>> BoundedAsyncPool<T> doCreatePool(Supplier<CompletionStage<T>> connectionSupplier, BoundedPoolConfig config, final boolean wrapConnections) {
        LettuceAssert.notNull(connectionSupplier, "Connection supplier must not be null");
        LettuceAssert.notNull((Object)config, "BoundedPoolConfig must not be null");
        final AtomicReference poolRef = new AtomicReference();
        BoundedAsyncPool pool = new BoundedAsyncPool<T>(new RedisPooledObjectFactory<T>(connectionSupplier), config, false){

            @Override
            public CompletableFuture<T> acquire() {
                CompletableFuture acquire = super.acquire();
                if (wrapConnections) {
                    return acquire.thenApply(it -> ConnectionWrapping.wrapConnection(it, (ConnectionWrapping.Origin)poolRef.get()));
                }
                return acquire;
            }

            @Override
            public CompletableFuture<Void> release(T object) {
                if (wrapConnections && object instanceof ConnectionWrapping.HasTargetConnection) {
                    return super.release(((ConnectionWrapping.HasTargetConnection)object).getTargetConnection());
                }
                return super.release(object);
            }
        };
        poolRef.set(new AsyncPoolWrapper(pool));
        return pool;
    }

    private static class AsyncPoolWrapper<T>
    implements ConnectionWrapping.Origin<T> {
        private final AsyncPool<T> pool;

        AsyncPoolWrapper(AsyncPool<T> pool) {
            this.pool = pool;
        }

        @Override
        public void returnObject(T o) {
            this.returnObjectAsync(o).join();
        }

        @Override
        public CompletableFuture<Void> returnObjectAsync(T o) {
            return this.pool.release(o);
        }
    }

    private static class RedisPooledObjectFactory<T extends StatefulConnection<?, ?>>
    implements AsyncObjectFactory<T> {
        private final Supplier<CompletionStage<T>> connectionSupplier;

        RedisPooledObjectFactory(Supplier<CompletionStage<T>> connectionSupplier) {
            this.connectionSupplier = connectionSupplier;
        }

        @Override
        public CompletableFuture<T> create() {
            return this.connectionSupplier.get().toCompletableFuture();
        }

        @Override
        public CompletableFuture<Void> destroy(T object) {
            return object.closeAsync();
        }

        @Override
        public CompletableFuture<Boolean> validate(T object) {
            return CompletableFuture.completedFuture(object.isOpen());
        }
    }
}

