/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.sparta;

import com.hp.hpl.sparta.CharCircBuffer;
import com.hp.hpl.sparta.Element;
import com.hp.hpl.sparta.EncodingMismatchException;
import com.hp.hpl.sparta.ParseException;
import com.hp.hpl.sparta.ParseHandler;
import com.hp.hpl.sparta.ParseLog;
import com.hp.hpl.sparta.ParseSource;
import com.hp.hpl.sparta.Sparta;
import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;

class ParseCharStream
implements ParseSource {
    private static final boolean DEBUG = true;
    private static final boolean H_DEBUG = false;
    private static final char[] NAME_PUNCT_CHARS = new char[]{'.', '-', '_', ':'};
    private static final int MAX_COMMON_CHAR = 128;
    private static final boolean[] IS_NAME_CHAR = new boolean[128];
    private static final char[] COMMENT_BEGIN;
    private static final char[] COMMENT_END;
    private static final char[] PI_BEGIN;
    private static final char[] QU_END;
    private static final char[] DOCTYPE_BEGIN;
    private static final char[] XML_BEGIN;
    private static final char[] ENCODING;
    private static final char[] VERSION;
    private static final char[] VERSIONNUM_PUNC_CHARS;
    private static final char[] MARKUPDECL_BEGIN;
    private static final char[] CHARREF_BEGIN;
    private static final char[] ENTITY_BEGIN;
    private static final char[] NDATA;
    private static final char[] SYSTEM;
    private static final char[] PUBLIC;
    private static final char[] BEGIN_CDATA;
    private static final char[] END_CDATA;
    private static final char[] END_EMPTYTAG;
    private static final char[] BEGIN_ETAG;
    private String systemId_;
    private String docTypeName_ = null;
    private final Reader reader_;
    private final Hashtable entities_ = new Hashtable();
    private final Hashtable pes_ = new Hashtable();
    private final ParseLog log_;
    private final String encoding_;
    private int ch_ = -2;
    private boolean isExternalDtd_ = false;
    private final int CBUF_SIZE = 1024;
    private final char[] cbuf_;
    private int curPos_ = 0;
    private int endPos_ = 0;
    private boolean eos_ = false;
    private static final int TMP_BUF_SIZE = 255;
    private final char[] tmpBuf_ = new char[255];
    private int lineNumber_ = 1;
    private final CharCircBuffer history_ = null;
    public static final int HISTORY_LENGTH = 100;
    private final ParseHandler handler_;

    public ParseCharStream(String systemId, char[] xmlData, ParseLog log, String encoding, ParseHandler handler) throws ParseException, EncodingMismatchException, IOException {
        this(systemId, null, xmlData, log, encoding, handler);
    }

    public ParseCharStream(String systemId, Reader reader, ParseLog log, String encoding, ParseHandler handler) throws ParseException, EncodingMismatchException, IOException {
        this(systemId, reader, null, log, encoding, handler);
    }

    public ParseCharStream(String systemId, Reader reader, char[] xmlData, ParseLog log, String encoding, ParseHandler handler) throws ParseException, EncodingMismatchException, IOException {
        this.log_ = log == null ? DEFAULT_LOG : log;
        this.encoding_ = encoding == null ? null : encoding.toLowerCase();
        this.entities_.put("lt", "<");
        this.entities_.put("gt", ">");
        this.entities_.put("amp", "&");
        this.entities_.put("apos", "'");
        this.entities_.put("quot", "\"");
        if (xmlData != null) {
            this.cbuf_ = xmlData;
            this.curPos_ = 0;
            this.endPos_ = this.cbuf_.length;
            this.eos_ = true;
            this.reader_ = null;
        } else {
            this.reader_ = reader;
            this.cbuf_ = new char[1024];
            this.fillBuf();
        }
        this.systemId_ = systemId;
        this.handler_ = handler;
        this.handler_.setParseSource(this);
        this.readProlog();
        this.handler_.startDocument();
        Element rootElement = this.readElement();
        if (this.docTypeName_ != null && !this.docTypeName_.equals(rootElement.getTagName())) {
            this.log_.warning("DOCTYPE name \"" + this.docTypeName_ + "\" not same as tag name, \"" + rootElement.getTagName() + "\" of root element", this.systemId_, this.getLineNumber());
        }
        while (this.isMisc()) {
            this.readMisc();
        }
        if (this.reader_ != null) {
            this.reader_.close();
        }
        this.handler_.endDocument();
    }

    @Override
    public String toString() {
        return this.systemId_;
    }

    @Override
    public String getSystemId() {
        return this.systemId_;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber_;
    }

    int getLastCharRead() {
        return this.ch_;
    }

    final String getHistory() {
        return "";
    }

    private int fillBuf() throws IOException {
        int count;
        if (this.eos_) {
            return -1;
        }
        if (this.endPos_ == this.cbuf_.length) {
            this.endPos_ = 0;
            this.curPos_ = 0;
        }
        if ((count = this.reader_.read(this.cbuf_, this.endPos_, this.cbuf_.length - this.endPos_)) <= 0) {
            this.eos_ = true;
            return -1;
        }
        this.endPos_ += count;
        return count;
    }

    private int fillBuf(int min) throws IOException {
        int res;
        if (this.eos_) {
            return -1;
        }
        int count = 0;
        if (this.cbuf_.length - this.curPos_ < min) {
            int i = 0;
            while (this.curPos_ + i < this.endPos_) {
                this.cbuf_[i] = this.cbuf_[this.curPos_ + i];
                ++i;
            }
            this.endPos_ = count = this.endPos_ - this.curPos_;
            this.curPos_ = 0;
        }
        if ((res = this.fillBuf()) == -1) {
            if (count == 0) {
                return -1;
            }
            return count;
        }
        return count + res;
    }

    private final char readChar() throws ParseException, IOException {
        if (this.curPos_ >= this.endPos_ && this.fillBuf() == -1) {
            throw new ParseException(this, "unexpected end of expression.");
        }
        if (this.cbuf_[this.curPos_] == '\n') {
            ++this.lineNumber_;
        }
        return this.cbuf_[this.curPos_++];
    }

    private final char peekChar() throws ParseException, IOException {
        if (this.curPos_ >= this.endPos_ && this.fillBuf() == -1) {
            throw new ParseException(this, "unexpected end of expression.");
        }
        return this.cbuf_[this.curPos_];
    }

    private final void readChar(char expected) throws ParseException, IOException {
        char ch = this.readChar();
        if (ch != expected) {
            throw new ParseException(this, ch, expected);
        }
    }

    private final boolean isChar(char expected) throws ParseException, IOException {
        if (this.curPos_ >= this.endPos_ && this.fillBuf() == -1) {
            throw new ParseException(this, "unexpected end of expression.");
        }
        return this.cbuf_[this.curPos_] == expected;
    }

    private final char readChar(char expect0, char expect1) throws ParseException, IOException {
        char ch = this.readChar();
        if (ch != expect0 && ch != expect1) {
            throw new ParseException(this, ch, new char[]{expect0, expect1});
        }
        return ch;
    }

    private final char readChar(char expect0, char expect1, char expect2, char expect3) throws ParseException, IOException {
        char ch = this.readChar();
        if (ch != expect0 && ch != expect1 && ch != expect2 && ch != expect3) {
            throw new ParseException(this, ch, new char[]{expect0, expect1, expect2, expect3});
        }
        return ch;
    }

    private final boolean isChar(char expect0, char expect1) throws ParseException, IOException {
        if (this.curPos_ >= this.endPos_ && this.fillBuf() == -1) {
            return false;
        }
        char ch = this.cbuf_[this.curPos_];
        return ch == expect0 || ch == expect1;
    }

    private final boolean isChar(char expect0, char expect1, char expect2, char expect3) throws ParseException, IOException {
        if (this.curPos_ >= this.endPos_ && this.fillBuf() == -1) {
            return false;
        }
        char ch = this.cbuf_[this.curPos_];
        return ch == expect0 || ch == expect1 || ch == expect2 || ch == expect3;
    }

    private static final boolean isIn(char ch, char[] expected) {
        for (int i = 0; i < expected.length; ++i) {
            if (ch != expected[i]) continue;
            return true;
        }
        return false;
    }

    private final void readS() throws ParseException, IOException {
        this.readChar(' ', '\t', '\r', '\n');
        while (this.isChar(' ', '\t', '\r', '\n')) {
            this.readChar();
        }
    }

    private final boolean isS() throws ParseException, IOException {
        return this.isChar(' ', '\t', '\r', '\n');
    }

    private boolean isNameChar() throws ParseException, IOException {
        char ch = this.peekChar();
        return ch < '\u0080' ? IS_NAME_CHAR[ch] : ParseCharStream.isNameChar(ch);
    }

    private static boolean isLetter(char ch) {
        return "abcdefghijklmnopqrstuvwxyz".indexOf(Character.toLowerCase(ch)) != -1;
    }

    private static boolean isNameChar(char ch) {
        return Character.isDigit(ch) || ParseCharStream.isLetter(ch) || ParseCharStream.isIn(ch, NAME_PUNCT_CHARS) || ParseCharStream.isExtender(ch);
    }

    private static boolean isExtender(char ch) {
        switch (ch) {
            case '\u00b7': 
            case '\u02d0': 
            case '\u02d1': 
            case '\u0387': 
            case '\u0640': 
            case '\u0e46': 
            case '\u0ec6': 
            case '\u3005': 
            case '\u3031': 
            case '\u3032': 
            case '\u3033': 
            case '\u3034': 
            case '\u3035': 
            case '\u309d': 
            case '\u309e': 
            case '\u30fc': 
            case '\u30fd': 
            case '\u30fe': {
                return true;
            }
        }
        return false;
    }

    private final String readName() throws ParseException, IOException {
        StringBuffer result = null;
        int i = 0;
        this.tmpBuf_[i++] = this.readNameStartChar();
        while (this.isNameChar()) {
            if (i >= 255) {
                if (result == null) {
                    result = new StringBuffer(i);
                    result.append(this.tmpBuf_, 0, i);
                } else {
                    result.append(this.tmpBuf_, 0, i);
                }
                i = 0;
            }
            this.tmpBuf_[i++] = this.readChar();
        }
        if (result == null) {
            return Sparta.intern(new String(this.tmpBuf_, 0, i));
        }
        result.append(this.tmpBuf_, 0, i);
        return result.toString();
    }

    private char readNameStartChar() throws ParseException, IOException {
        char ch = this.readChar();
        if (!ParseCharStream.isLetter(ch) && ch != '_' && ch != ':') {
            throw new ParseException(this, ch, "letter, underscore, colon");
        }
        return ch;
    }

    private final String readEntityValue() throws ParseException, IOException {
        char quote = this.readChar('\'', '\"');
        StringBuffer result = new StringBuffer();
        while (!this.isChar(quote)) {
            if (this.isPeReference()) {
                result.append(this.readPeReference());
                continue;
            }
            if (this.isReference()) {
                result.append(this.readReference());
                continue;
            }
            result.append(this.readChar());
        }
        this.readChar(quote);
        return result.toString();
    }

    private final boolean isEntityValue() throws ParseException, IOException {
        return this.isChar('\'', '\"');
    }

    private final void readSystemLiteral() throws ParseException, IOException {
        char quote = this.readChar();
        while (this.peekChar() != quote) {
            this.readChar();
        }
        this.readChar(quote);
    }

    private final void readPubidLiteral() throws ParseException, IOException {
        this.readSystemLiteral();
    }

    private boolean isMisc() throws ParseException, IOException {
        return this.isComment() || this.isPi() || this.isS();
    }

    private void readMisc() throws ParseException, IOException {
        if (this.isComment()) {
            this.readComment();
        } else if (this.isPi()) {
            this.readPi();
        } else if (this.isS()) {
            this.readS();
        } else {
            throw new ParseException(this, "expecting comment or processing instruction or space");
        }
    }

    private final void readComment() throws ParseException, IOException {
        this.readSymbol(COMMENT_BEGIN);
        while (!this.isSymbol(COMMENT_END)) {
            this.readChar();
        }
        this.readSymbol(COMMENT_END);
    }

    private final boolean isComment() throws ParseException, IOException {
        return this.isSymbol(COMMENT_BEGIN);
    }

    private final void readPi() throws ParseException, IOException {
        this.readSymbol(PI_BEGIN);
        while (!this.isSymbol(QU_END)) {
            this.readChar();
        }
        this.readSymbol(QU_END);
    }

    private final boolean isPi() throws ParseException, IOException {
        return this.isSymbol(PI_BEGIN);
    }

    private void readProlog() throws ParseException, EncodingMismatchException, IOException {
        if (this.isXmlDecl()) {
            this.readXmlDecl();
        }
        while (this.isMisc()) {
            this.readMisc();
        }
        if (this.isDocTypeDecl()) {
            this.readDocTypeDecl();
            while (this.isMisc()) {
                this.readMisc();
            }
        }
    }

    private boolean isDocTypeDecl() throws ParseException, IOException {
        return this.isSymbol(DOCTYPE_BEGIN);
    }

    private void readXmlDecl() throws ParseException, EncodingMismatchException, IOException {
        this.readSymbol(XML_BEGIN);
        this.readVersionInfo();
        if (this.isS()) {
            this.readS();
        }
        if (this.isEncodingDecl()) {
            String encodingDeclared = this.readEncodingDecl();
            if (this.encoding_ != null && !encodingDeclared.toLowerCase().equals(this.encoding_)) {
                throw new EncodingMismatchException(this.systemId_, encodingDeclared, this.encoding_);
            }
        }
        while (!this.isSymbol(QU_END)) {
            this.readChar();
        }
        this.readSymbol(QU_END);
    }

    private boolean isXmlDecl() throws ParseException, IOException {
        return this.isSymbol(XML_BEGIN);
    }

    private boolean isEncodingDecl() throws ParseException, IOException {
        return this.isSymbol(ENCODING);
    }

    private String readEncodingDecl() throws ParseException, IOException {
        this.readSymbol(ENCODING);
        this.readEq();
        char quote = this.readChar('\'', '\"');
        StringBuffer result = new StringBuffer();
        while (!this.isChar(quote)) {
            result.append(this.readChar());
        }
        this.readChar(quote);
        return result.toString();
    }

    private void readVersionInfo() throws ParseException, IOException {
        this.readS();
        this.readSymbol(VERSION);
        this.readEq();
        char quote = this.readChar('\'', '\"');
        this.readVersionNum();
        this.readChar(quote);
    }

    private final void readEq() throws ParseException, IOException {
        if (this.isS()) {
            this.readS();
        }
        this.readChar('=');
        if (this.isS()) {
            this.readS();
        }
    }

    private boolean isVersionNumChar() throws ParseException, IOException {
        char ch = this.peekChar();
        return Character.isDigit(ch) || 'a' <= ch && ch <= 'z' || 'Z' <= ch && ch <= 'Z' || ParseCharStream.isIn(ch, VERSIONNUM_PUNC_CHARS);
    }

    private void readVersionNum() throws ParseException, IOException {
        this.readChar();
        while (this.isVersionNumChar()) {
            this.readChar();
        }
    }

    private void readDocTypeDecl() throws ParseException, IOException {
        this.readSymbol(DOCTYPE_BEGIN);
        this.readS();
        this.docTypeName_ = this.readName();
        if (this.isS()) {
            this.readS();
            if (!this.isChar('>') && !this.isChar('[')) {
                this.isExternalDtd_ = true;
                this.readExternalId();
                if (this.isS()) {
                    this.readS();
                }
            }
        }
        if (this.isChar('[')) {
            this.readChar();
            while (!this.isChar(']')) {
                if (this.isDeclSep()) {
                    this.readDeclSep();
                    continue;
                }
                this.readMarkupDecl();
            }
            this.readChar(']');
            if (this.isS()) {
                this.readS();
            }
        }
        this.readChar('>');
    }

    private void readDeclSep() throws ParseException, IOException {
        if (this.isPeReference()) {
            this.readPeReference();
        } else {
            this.readS();
        }
    }

    private boolean isDeclSep() throws ParseException, IOException {
        return this.isPeReference() || this.isS();
    }

    private void readMarkupDecl() throws ParseException, IOException {
        if (this.isPi()) {
            this.readPi();
        } else if (this.isComment()) {
            this.readComment();
        } else if (this.isEntityDecl()) {
            this.readEntityDecl();
        } else if (this.isSymbol(MARKUPDECL_BEGIN)) {
            while (!this.isChar('>')) {
                if (this.isChar('\'', '\"')) {
                    char quote = this.readChar();
                    while (!this.isChar(quote)) {
                        this.readChar();
                    }
                    this.readChar(quote);
                    continue;
                }
                this.readChar();
            }
            this.readChar('>');
        } else {
            throw new ParseException(this, "expecting processing instruction, comment, or \"<!\"");
        }
    }

    private char readCharRef() throws ParseException, IOException {
        this.readSymbol(CHARREF_BEGIN);
        int radix = 10;
        if (this.isChar('x')) {
            this.readChar();
            radix = 16;
        }
        int i = 0;
        while (!this.isChar(';')) {
            this.tmpBuf_[i++] = this.readChar();
            if (i < 255) continue;
            this.log_.warning("Tmp buffer overflow on readCharRef", this.systemId_, this.getLineNumber());
            return ' ';
        }
        this.readChar(';');
        String num = new String(this.tmpBuf_, 0, i);
        try {
            return (char)Integer.parseInt(num, radix);
        }
        catch (NumberFormatException e) {
            this.log_.warning("\"" + num + "\" is not a valid " + (radix == 16 ? "hexadecimal" : "decimal") + " number", this.systemId_, this.getLineNumber());
            return ' ';
        }
    }

    private final char[] readReference() throws ParseException, IOException {
        if (this.isSymbol(CHARREF_BEGIN)) {
            return new char[]{this.readCharRef()};
        }
        return this.readEntityRef().toCharArray();
    }

    private final boolean isReference() throws ParseException, IOException {
        return this.isChar('&');
    }

    private String readEntityRef() throws ParseException, IOException {
        this.readChar('&');
        String name = this.readName();
        String result = (String)this.entities_.get(name);
        if (result == null) {
            result = "";
            if (this.isExternalDtd_) {
                this.log_.warning("&" + name + "; not found -- possibly defined in external DTD)", this.systemId_, this.getLineNumber());
            } else {
                this.log_.warning("No declaration of &" + name + ";", this.systemId_, this.getLineNumber());
            }
        }
        this.readChar(';');
        return result;
    }

    private String readPeReference() throws ParseException, IOException {
        this.readChar('%');
        String name = this.readName();
        String result = (String)this.pes_.get(name);
        if (result == null) {
            result = "";
            this.log_.warning("No declaration of %" + name + ";", this.systemId_, this.getLineNumber());
        }
        this.readChar(';');
        return result;
    }

    private boolean isPeReference() throws ParseException, IOException {
        return this.isChar('%');
    }

    private void readEntityDecl() throws ParseException, IOException {
        this.readSymbol(ENTITY_BEGIN);
        this.readS();
        if (this.isChar('%')) {
            this.readChar('%');
            this.readS();
            String name = this.readName();
            this.readS();
            String value = this.isEntityValue() ? this.readEntityValue() : this.readExternalId();
            this.pes_.put(name, value);
        } else {
            String value;
            String name = this.readName();
            this.readS();
            if (this.isEntityValue()) {
                value = this.readEntityValue();
            } else if (this.isExternalId()) {
                value = this.readExternalId();
                if (this.isS()) {
                    this.readS();
                }
                if (this.isSymbol(NDATA)) {
                    this.readSymbol(NDATA);
                    this.readS();
                    this.readName();
                }
            } else {
                throw new ParseException(this, "expecting double-quote, \"PUBLIC\" or \"SYSTEM\" while reading entity declaration");
            }
            this.entities_.put(name, value);
        }
        if (this.isS()) {
            this.readS();
        }
        this.readChar('>');
    }

    private boolean isEntityDecl() throws ParseException, IOException {
        return this.isSymbol(ENTITY_BEGIN);
    }

    private String readExternalId() throws ParseException, IOException {
        if (this.isSymbol(SYSTEM)) {
            this.readSymbol(SYSTEM);
        } else if (this.isSymbol(PUBLIC)) {
            this.readSymbol(PUBLIC);
            this.readS();
            this.readPubidLiteral();
        } else {
            throw new ParseException(this, "expecting \"SYSTEM\" or \"PUBLIC\" while reading external ID");
        }
        this.readS();
        this.readSystemLiteral();
        return "(WARNING: external ID not read)";
    }

    private boolean isExternalId() throws ParseException, IOException {
        return this.isSymbol(SYSTEM) || this.isSymbol(PUBLIC);
    }

    private final void readSymbol(char[] expected) throws ParseException, IOException {
        int n = expected.length;
        if (this.endPos_ - this.curPos_ < n && this.fillBuf(n) <= 0) {
            this.ch_ = -1;
            throw new ParseException(this, "end of XML file", expected);
        }
        this.ch_ = this.cbuf_[this.endPos_ - 1];
        if (this.endPos_ - this.curPos_ < n) {
            throw new ParseException(this, "end of XML file", expected);
        }
        for (int i = 0; i < n; ++i) {
            if (this.cbuf_[this.curPos_ + i] == expected[i]) continue;
            throw new ParseException(this, new String(this.cbuf_, this.curPos_, n), expected);
        }
        this.curPos_ += n;
    }

    private final boolean isSymbol(char[] expected) throws ParseException, IOException {
        int n = expected.length;
        if (this.endPos_ - this.curPos_ < n && this.fillBuf(n) <= 0) {
            this.ch_ = -1;
            return false;
        }
        this.ch_ = this.cbuf_[this.endPos_ - 1];
        if (this.endPos_ - this.curPos_ < n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.cbuf_[this.curPos_ + i] == expected[i]) continue;
            return false;
        }
        return true;
    }

    private String readAttValue() throws ParseException, IOException {
        char quote = this.readChar('\'', '\"');
        StringBuffer result = new StringBuffer();
        while (!this.isChar(quote)) {
            if (this.isReference()) {
                result.append(this.readReference());
                continue;
            }
            result.append(this.readChar());
        }
        this.readChar(quote);
        return result.toString();
    }

    private void readPossibleCharData() throws ParseException, IOException {
        int i = 0;
        while (!(this.isChar('<') || this.isChar('&') || this.isSymbol(END_CDATA))) {
            this.tmpBuf_[i] = this.readChar();
            if (this.tmpBuf_[i] == '\r' && this.peekChar() == '\n') {
                this.tmpBuf_[i] = this.readChar();
            }
            if (++i != 255) continue;
            this.handler_.characters(this.tmpBuf_, 0, 255);
            i = 0;
        }
        if (i > 0) {
            this.handler_.characters(this.tmpBuf_, 0, i);
        }
    }

    private void readCdSect() throws ParseException, IOException {
        StringBuffer result = null;
        this.readSymbol(BEGIN_CDATA);
        int i = 0;
        while (!this.isSymbol(END_CDATA)) {
            if (i >= 255) {
                if (result == null) {
                    result = new StringBuffer(i);
                    result.append(this.tmpBuf_, 0, i);
                } else {
                    result.append(this.tmpBuf_, 0, i);
                }
                i = 0;
            }
            this.tmpBuf_[i++] = this.readChar();
        }
        this.readSymbol(END_CDATA);
        if (result != null) {
            result.append(this.tmpBuf_, 0, i);
            char[] cdSect = result.toString().toCharArray();
            this.handler_.characters(cdSect, 0, cdSect.length);
        } else {
            this.handler_.characters(this.tmpBuf_, 0, i);
        }
    }

    private boolean isCdSect() throws ParseException, IOException {
        return this.isSymbol(BEGIN_CDATA);
    }

    private final Element readElement() throws ParseException, IOException {
        Element element = new Element();
        boolean isSTag = this.readEmptyElementTagOrSTag(element);
        this.handler_.startElement(element);
        if (isSTag) {
            this.readContent();
            this.readETag(element);
        }
        this.handler_.endElement(element);
        return element;
    }

    ParseLog getLog() {
        return this.log_;
    }

    private boolean readEmptyElementTagOrSTag(Element element) throws ParseException, IOException {
        boolean isSTag;
        this.readChar('<');
        element.setTagName(this.readName());
        while (this.isS()) {
            this.readS();
            if (this.isChar('/', '>')) continue;
            this.readAttribute(element);
        }
        if (this.isS()) {
            this.readS();
        }
        if (isSTag = this.isChar('>')) {
            this.readChar('>');
        } else {
            this.readSymbol(END_EMPTYTAG);
        }
        return isSTag;
    }

    private void readAttribute(Element element) throws ParseException, IOException {
        String name = this.readName();
        this.readEq();
        String value = this.readAttValue();
        if (element.getAttribute(name) != null) {
            this.log_.warning("Element " + this + " contains attribute " + name + "more than once", this.systemId_, this.getLineNumber());
        }
        element.setAttribute(name, value);
    }

    private void readETag(Element element) throws ParseException, IOException {
        this.readSymbol(BEGIN_ETAG);
        String name = this.readName();
        if (!name.equals(element.getTagName())) {
            this.log_.warning("end tag (" + name + ") does not match begin tag (" + element.getTagName() + ")", this.systemId_, this.getLineNumber());
        }
        if (this.isS()) {
            this.readS();
        }
        this.readChar('>');
    }

    private boolean isETag() throws ParseException, IOException {
        return this.isSymbol(BEGIN_ETAG);
    }

    private void readContent() throws ParseException, IOException {
        this.readPossibleCharData();
        boolean keepGoing = true;
        while (keepGoing) {
            if (this.isETag()) {
                keepGoing = false;
            } else if (this.isReference()) {
                char[] ref = this.readReference();
                this.handler_.characters(ref, 0, ref.length);
            } else if (this.isCdSect()) {
                this.readCdSect();
            } else if (this.isPi()) {
                this.readPi();
            } else if (this.isComment()) {
                this.readComment();
            } else if (this.isChar('<')) {
                this.readElement();
            } else {
                keepGoing = false;
            }
            this.readPossibleCharData();
        }
    }

    static {
        for (char ch = '\u0000'; ch < '\u0080'; ch = (char)(ch + '\u0001')) {
            ParseCharStream.IS_NAME_CHAR[ch] = ParseCharStream.isNameChar(ch);
        }
        COMMENT_BEGIN = "<!--".toCharArray();
        COMMENT_END = "-->".toCharArray();
        PI_BEGIN = "<?".toCharArray();
        QU_END = "?>".toCharArray();
        DOCTYPE_BEGIN = "<!DOCTYPE".toCharArray();
        XML_BEGIN = "<?xml".toCharArray();
        ENCODING = "encoding".toCharArray();
        VERSION = "version".toCharArray();
        VERSIONNUM_PUNC_CHARS = new char[]{'_', '.', ':', '-'};
        MARKUPDECL_BEGIN = "<!".toCharArray();
        CHARREF_BEGIN = "&#".toCharArray();
        ENTITY_BEGIN = "<!ENTITY".toCharArray();
        NDATA = "NDATA".toCharArray();
        SYSTEM = "SYSTEM".toCharArray();
        PUBLIC = "PUBLIC".toCharArray();
        BEGIN_CDATA = "<![CDATA[".toCharArray();
        END_CDATA = "]]>".toCharArray();
        END_EMPTYTAG = "/>".toCharArray();
        BEGIN_ETAG = "</".toCharArray();
    }
}

